document.addEventListener('DOMContentLoaded', () => {
    // --- 1. Animation Logic (IntersectionObserver) ---
    const observerOptions = {
        root: null,
        rootMargin: '0px',
        threshold: 0.1 // Trigger when 10% of element is visible
    };

    const observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const target = entry.target;
                const delay = parseInt(target.getAttribute('data-delay') || '0', 10);

                setTimeout(() => {
                    target.classList.add('revealed');
                }, delay);
                
                observer.unobserve(target);
            }
        });
    }, observerOptions);

    // Apply observer to all animatable elements
    document.querySelectorAll('.hidden-fade-in, .hidden-slide-up').forEach(el => {
        observer.observe(el);
    });

    // --- 2. Form Validation and Submission ---
    const form = document.getElementById('contact-form');
    const formStatus = document.getElementById('form-status');

    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        let isValid = true;
        const requiredFields = this.querySelectorAll('[required]');

        // Clear previous error messages
        this.querySelectorAll('.error-message').forEach(el => el.textContent = '');
        formStatus.textContent = '';
        formStatus.classList.remove('success', 'error');

        // Check required fields
        requiredFields.forEach(input => {
            if (!input.value.trim()) {
                isValid = false;
                const errorEl = input.nextElementSibling;
                if (errorEl && errorEl.classList.contains('error-message')) {
                    errorEl.textContent = `${input.previousElementSibling.textContent.replace(' *', '').replace(' (Optional)', '')} is required.`;
                }
            }
        });

        if (isValid) {
            // Simulate form submission success
            console.log('Form data:', new FormData(this));
            
            formStatus.textContent = 'Thank you! Your message has been sent successfully.';
            formStatus.classList.add('success');
            
            // Optionally clear the form
            this.reset();
        } else {
            formStatus.textContent = 'Please correct the errors in the form.';
            formStatus.classList.add('error');
        }
    });

    // --- 3. Modal Logic ---
    const modalOverlay = document.getElementById('contact-modal');
    const modalContent = modalOverlay.querySelector('.modal-content');
    const modalCloseBtn = modalOverlay.querySelector('.modal-close');
    const modalTitle = document.getElementById('modal-title');
    const modalBody = document.getElementById('modal-body');

    function openModal(title, content) {
        modalTitle.textContent = title;
        modalBody.innerHTML = content;
        modalOverlay.classList.remove('hidden-modal');
        modalContent.classList.remove('hidden-modal');
        document.body.style.overflow = 'hidden'; // Prevent background scrolling
    }

    function closeModal() {
        modalOverlay.classList.add('hidden-modal');
        modalContent.classList.add('hidden-modal');
        document.body.style.overflow = '';
    }

    // Close Modal listeners
    modalCloseBtn.addEventListener('click', closeModal);
    modalOverlay.addEventListener('click', (e) => {
        if (e.target === modalOverlay) {
            closeModal();
        }
    });

    // --- 4. CTA Button Handlers (Prayer Request & Map) ---
    const prayerCta = document.getElementById('prayer-cta');
    const mapCta = document.getElementById('map-cta');
    const formSection = document.getElementById('contact-form-section');

    // Smooth scroll to form for Prayer Request button
    if (prayerCta) {
        prayerCta.addEventListener('click', () => {
            // Change subject to 'Prayer Request' and smoothly scroll to form
            const subjectSelect = document.getElementById('subject');
            if(subjectSelect) {
                subjectSelect.value = 'Prayer Request';
            }
            formSection.scrollIntoView({ behavior: 'smooth', block: 'start' });
            
            // Highlight the subject field briefly
            formSection.classList.add('highlight');
            setTimeout(() => {
                formSection.classList.remove('highlight');
            }, 1000);
        });
    }

    // Open Modal for Map button
    if (mapCta) {
        mapCta.addEventListener('click', () => {
            const mapContent = `
                <p class="text-gray-700 mb-4">Our church is located at <strong>1470 Glory Road, Faith City, USA 90210</strong>. We look forward to seeing you!</p>
                <div style="height: 250px; background-color: #e0e0e0; border-radius: 8px; display: flex; align-items: center; justify-content: center; border: 1px solid #ccc;">
                    <p style="color: #6b6b6b; font-weight: 600;">[Actual Google Map Embed goes here]</p>
                </div>
            `;
            openModal('Ministry Location', mapContent);
        });
    }

});document.addEventListener('DOMContentLoaded', () => {
    // --- 1. Animation Logic (IntersectionObserver) ---
    const observerOptions = {
        root: null,
        rootMargin: '0px',
        threshold: 0.1 // Trigger when 10% of element is visible
    };

    const observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const target = entry.target;
                const delay = parseInt(target.getAttribute('data-delay') || '0', 10);

                setTimeout(() => {
                    target.classList.add('revealed');
                }, delay);
                
                observer.unobserve(target);
            }
        });
    }, observerOptions);

    // Apply observer to all animatable elements
    document.querySelectorAll('.hidden-fade-in, .hidden-slide-up').forEach(el => {
        observer.observe(el);
    });

    // --- 2. Form Validation and Submission ---
    const form = document.getElementById('contact-form');
    const formStatus = document.getElementById('form-status');

    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        let isValid = true;
        const requiredFields = this.querySelectorAll('[required]');

        // Clear previous error messages
        this.querySelectorAll('.error-message').forEach(el => el.textContent = '');
        formStatus.textContent = '';
        formStatus.classList.remove('success', 'error');

        // Check required fields
        requiredFields.forEach(input => {
            if (!input.value.trim()) {
                isValid = false;
                const errorEl = input.nextElementSibling;
                if (errorEl && errorEl.classList.contains('error-message')) {
                    errorEl.textContent = `${input.previousElementSibling.textContent.replace(' *', '').replace(' (Optional)', '')} is required.`;
                }
            }
        });

        if (isValid) {
            // Simulate form submission success
            console.log('Form data:', new FormData(this));
            
            formStatus.textContent = 'Thank you! Your message has been sent successfully.';
            formStatus.classList.add('success');
            
            // Optionally clear the form
            this.reset();
        } else {
            formStatus.textContent = 'Please correct the errors in the form.';
            formStatus.classList.add('error');
        }
    });

    // --- 3. Modal Logic ---
    const modalOverlay = document.getElementById('contact-modal');
    const modalContent = modalOverlay.querySelector('.modal-content');
    const modalCloseBtn = modalOverlay.querySelector('.modal-close');
    const modalTitle = document.getElementById('modal-title');
    const modalBody = document.getElementById('modal-body');

    function openModal(title, content) {
        modalTitle.textContent = title;
        modalBody.innerHTML = content;
        modalOverlay.classList.remove('hidden-modal');
        modalContent.classList.remove('hidden-modal');
        document.body.style.overflow = 'hidden'; // Prevent background scrolling
    }

    function closeModal() {
        modalOverlay.classList.add('hidden-modal');
        modalContent.classList.add('hidden-modal');
        document.body.style.overflow = '';
    }

    // Close Modal listeners
    modalCloseBtn.addEventListener('click', closeModal);
    modalOverlay.addEventListener('click', (e) => {
        if (e.target === modalOverlay) {
            closeModal();
        }
    });

    // --- 4. CTA Button Handlers (Prayer Request & Map) ---
    const prayerCta = document.getElementById('prayer-cta');
    const mapCta = document.getElementById('map-cta');
    const formSection = document.getElementById('contact-form-section');

    // Smooth scroll to form for Prayer Request button
    if (prayerCta) {
        prayerCta.addEventListener('click', () => {
            // Change subject to 'Prayer Request' and smoothly scroll to form
            const subjectSelect = document.getElementById('subject');
            if(subjectSelect) {
                subjectSelect.value = 'Prayer Request';
            }
            formSection.scrollIntoView({ behavior: 'smooth', block: 'start' });
            
            // Highlight the subject field briefly
            formSection.classList.add('highlight');
            setTimeout(() => {
                formSection.classList.remove('highlight');
            }, 1000);
        });
    }

    // Open Modal for Map button
    if (mapCta) {
        mapCta.addEventListener('click', () => {
            const mapContent = `
                <p class="text-gray-700 mb-4">Our church is located at <strong>1470 Glory Road, Faith City, USA 90210</strong>. We look forward to seeing you!</p>
                <div style="height: 250px; background-color: #e0e0e0; border-radius: 8px; display: flex; align-items: center; justify-content: center; border: 1px solid #ccc;">
                    <p style="color: #6b6b6b; font-weight: 600;">[Actual Google Map Embed goes here]</p>
                </div>
            `;
            openModal('Ministry Location', mapContent);
        });
    }

});