// Enhanced JavaScript with better functionality
document.addEventListener('DOMContentLoaded', function() {
    // Mobile menu toggle
    const mobileMenuBtn = document.getElementById('mobile-menu');
    const navMenu = document.getElementById('nav-menu');
    
    mobileMenuBtn.addEventListener('click', function() {
        navMenu.classList.toggle('show');
        // Change icon based on menu state
        const icon = this.querySelector('i');
        if (navMenu.classList.contains('show')) {
            icon.classList.remove('fa-bars');
            icon.classList.add('fa-times');
        } else {
            icon.classList.remove('fa-times');
            icon.classList.add('fa-bars');
        }
    });
    
    // Mobile dropdown functionality
    const dropdownItems = document.querySelectorAll('.dropdown');

    dropdownItems.forEach(item => {
      const dropdownLink = item.querySelector('a.dropdown-link');
      const dropdownToggle = item.querySelector('.dropdown-toggle');
      const dropdownMenu = item.querySelector('.dropdown-menu');

      // Ensure initial ARIA state on the toggle (if present)
      if (dropdownToggle && dropdownMenu) {
        dropdownToggle.setAttribute('aria-expanded', 'false');
        dropdownMenu.setAttribute('aria-hidden', 'true');
      }

      if (dropdownToggle) {
        dropdownToggle.addEventListener('click', function(e) {
          if (window.innerWidth <= 767) {
            e.preventDefault();
            const isOpen = dropdownMenu.classList.toggle('show');
            // Update ARIA attributes
            dropdownToggle.setAttribute('aria-expanded', String(isOpen));
            dropdownMenu.setAttribute('aria-hidden', String(!isOpen));

            // Rotate chevron icon
            const icon = this.querySelector('i');
            if (icon) {
              icon.classList.toggle('fa-chevron-down', !isOpen);
              icon.classList.toggle('fa-chevron-up', isOpen);
            }
          }
        });
      }
    });
    
    // Close mobile menu when clicking on any nav link (submenus will also close when a submenu link is chosen)
    const navLinks = document.querySelectorAll('nav a');
    navLinks.forEach(link => {
      link.addEventListener('click', function() {
        if (navMenu.classList.contains('show') && window.innerWidth <= 767) {
          navMenu.classList.remove('show');
          const icon = mobileMenuBtn.querySelector('i');
          icon.classList.remove('fa-times');
          icon.classList.add('fa-bars');
        }
      });
    });
    
    // Hide top bar on scroll
    const topBar = document.getElementById('top-bar');
    let lastScrollY = window.scrollY;
    
    window.addEventListener('scroll', function() {
        if (window.scrollY > lastScrollY && window.scrollY > 100) {
            topBar.classList.add('hidden');
        } else {
            topBar.classList.remove('hidden');
        }
        lastScrollY = window.scrollY;
    });
    
    // Smooth scrolling for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function(e) {
            e.preventDefault();
            
            const targetId = this.getAttribute('href');
            if (targetId === '#') return;
            
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                const headerHeight = document.getElementById('header').offsetHeight;
                const targetPosition = targetElement.getBoundingClientRect().top + window.pageYOffset - headerHeight;
                
                window.scrollTo({
                    top: targetPosition,
                    behavior: 'smooth'
                });
            }
        });
    });
    
    // Carousel functionality
    const carouselSlides = document.querySelectorAll('.carousel-slide');
    const carouselDots = document.querySelectorAll('.carousel-dot');
    const prevButton = document.querySelector('.carousel-arrow.prev');
    const nextButton = document.querySelector('.carousel-arrow.next');
    let currentSlide = 0;
    
    function showSlide(index) {
        // Hide all slides
        carouselSlides.forEach(slide => {
            slide.classList.remove('active');
        });
        
        // Remove active class from all dots
        carouselDots.forEach(dot => {
            dot.classList.remove('active');
        });
        
        // Show the selected slide
        carouselSlides[index].classList.add('active');
        carouselDots[index].classList.add('active');
        currentSlide = index;
    }
    
    function nextSlide() {
        let nextIndex = (currentSlide + 1) % carouselSlides.length;
        showSlide(nextIndex);
    }
    
    function prevSlide() {
        let prevIndex = (currentSlide - 1 + carouselSlides.length) % carouselSlides.length;
        showSlide(prevIndex);
    }
    
    // Event listeners for carousel controls
    nextButton.addEventListener('click', nextSlide);
    prevButton.addEventListener('click', prevSlide);
    
    // Add click events to dots
    carouselDots.forEach((dot, index) => {
        dot.addEventListener('click', () => {
            showSlide(index);
        });
    });
    
    // Auto-advance carousel
    let carouselInterval = setInterval(nextSlide, 5000);
    
    // Pause auto-advance on hover
    const carousel = document.querySelector('.carousel');
    carousel.addEventListener('mouseenter', () => {
        clearInterval(carouselInterval);
    });
    
    carousel.addEventListener('mouseleave', () => {
        carouselInterval = setInterval(nextSlide, 5000);
    });
});






// Scroll animation trigger
document.addEventListener('DOMContentLoaded', function() {
  const givingCard = document.querySelector('.giving-card');
  
  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.style.animationPlayState = 'running';
      }
    });
  }, {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
  });
  
  givingCard.style.animationPlayState = 'paused';
  observer.observe(givingCard);
});
