/**
 * services.js
 * Handles the Intersection Observer for section and card animations.
 */

document.addEventListener('DOMContentLoaded', () => {

    // --- Intersection Observer Setup ---
    const observerOptions = {
        root: null, // Viewport as the root
        rootMargin: '0px',
        threshold: 0.1 // Trigger when 10% of the item is visible
    };

    const observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const element = entry.target;
                const delayAttr = element.getAttribute('data-delay');
                const delay = delayAttr ? parseFloat(delayAttr) * 1000 : 0;

                // Apply the 'visible' class after the stagger delay
                setTimeout(() => {
                    element.classList.add('visible');
                }, delay);

                // Stop observing once the element is visible
                observer.unobserve(element);
            }
        });
    }, observerOptions);

    // Apply observer to all elements designated for sliding reveal (section headers and cards)
    document.querySelectorAll('.reveal-slide').forEach(el => observer.observe(el));
});